--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- Provides support for interacting with json data through an extended dkjson module.
--- @class jsonlib
--- @field null number You can use this value for setting explicit null values.
--- @field version string Current version of dkjson.
json = {}

--- Decode string into a table.
--- 
--- !!! warning "json does not support mixed `string` and `number` indices"
--- 	If the encoded table had any `string` indices, then the `table` returned by this function will have no `number` indices. For example, `[1]` could have been converted to `["1"]` in the encoding process.
--- 
--- @param s string No description yet available.
--- @param position? number *Default*: `1`. No description yet available.
--- @param nullValue? string *Optional*. No description yet available.
--- @return table result No description yet available.
function json.decode(s, position, nullValue) end

--- Create a string representing the object. Object can be a `table`, `string`, `number`, `boolean`, `nil`, `json.null`,  or any object with a `__tojson` function in its `metatable`. A `table` can only use strings and numbers as keys, and its values have to be valid objects as well. This function will raise an error if called on an invalid data type or on a data structure that contains reference cycles.
--- 
--- !!! warning "json does not support mixed `string` and `number` indices"
--- 	If the encoded table has any `string` indices, then this function will convert all `number` indices to `string` indices. For example, `[1]` could be converted to `["1"]`. This should be taken into account when loading/decoding json files.
--- 
--- @param object table No description yet available.
--- @param state? jsonConfig *Optional*. No description yet available.
--- @return string result No description yet available.
function json.encode(object, state) end

--- Loads the contents of a file through `json.decode`. Files loaded from "Data Files\\MWSE\\{`fileName`}.json".
--- 
--- !!! warning "json does not support mixed `string` and `number` indices"
--- 	If the encoded table had any `string` indices, then the `table` returned by this function will have no `number` indices. For example, `[1]` could have been converted to `["1"]` in the encoding process.
--- 	If you're using this to load a configuration file for your mod, it's recommended you use [`mwse.loadConfig`](https://mwse.github.io/MWSE/apis/mwse/#mwseloadconfig) instead.
--- 
--- @param fileName string No description yet available.
--- @return table result No description yet available.
function json.loadfile(fileName) end

--- Quote a UTF-8 string and escape critical characters using JSON escape sequences. This function is only necessary when you build your own __tojson functions.
--- @param s string No description yet available.
--- @return string result No description yet available.
function json.quotestring(s) end

--- Saves a serializable table to Data Files\\MWSE\\{`fileName`}.json, using `json.encode`.
--- @param fileName string No description yet available.
--- @param object table No description yet available.
--- @param config? jsonConfig *Optional*. No description yet available.
function json.savefile(fileName, object, config) end

